/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import qouteall.imm_ptl.peripheral.alternate_dimension.ChaosBiomeSource;
import qouteall.imm_ptl.peripheral.alternate_dimension.DelegatedChunkGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.RegionErrorTerrainGenerator;
import qouteall.q_misc_util.Helper;

public class ErrorTerrainGenerator
extends DelegatedChunkGenerator {
    public static final Codec<ErrorTerrainGenerator> codec = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_255175_((ResourceKey)Registries.f_256952_), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_256932_), (App)RegistryOps.m_255175_((ResourceKey)Registries.f_273919_)).apply((Applicative)instance, ErrorTerrainGenerator::create));
    public static final int regionChunkNum = 4;
    public static final int averageY = 64;
    public static final int maxY = 128;
    private final BlockState air = Blocks.f_50016_.m_49966_();
    private final BlockState defaultBlock = Blocks.f_50069_.m_49966_();
    private final BlockState defaultFluid = Blocks.f_49990_.m_49966_();
    private final LoadingCache<ChunkPos, RegionErrorTerrainGenerator> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ChunkPos, RegionErrorTerrainGenerator>(){

        public RegionErrorTerrainGenerator load(ChunkPos key) {
            return new RegionErrorTerrainGenerator(key.f_45578_, key.f_45579_, System.nanoTime());
        }
    });

    public static ErrorTerrainGenerator create(HolderGetter<Biome> biomeHolderGetter, HolderGetter<NoiseGeneratorSettings> noiseGeneratorSettingsHolderGetter, HolderGetter<MultiNoiseBiomeSourceParameterList> multiNoiseBiomeSourceParameterListHolderGetter) {
        ChaosBiomeSource chaosBiomeSource = ChaosBiomeSource.createChaosBiomeSource(biomeHolderGetter, multiNoiseBiomeSourceParameterListHolderGetter);
        NoiseGeneratorSettings skylandSetting = (NoiseGeneratorSettings)noiseGeneratorSettingsHolderGetter.m_255043_(NoiseGeneratorSettings.f_64437_).m_203334_();
        NoiseBasedChunkGenerator islandChunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)chaosBiomeSource, Holder.m_205709_((Object)skylandSetting));
        return new ErrorTerrainGenerator(chaosBiomeSource, (ChunkGenerator)islandChunkGenerator);
    }

    public ErrorTerrainGenerator(BiomeSource biomeSource, ChunkGenerator delegate) {
        super(biomeSource, delegate);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return codec;
    }

    @Override
    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        LevelChunkSection[] sectionArray = chunkAccess.m_7103_();
        ArrayList<LevelChunkSection> locked = new ArrayList<LevelChunkSection>();
        for (LevelChunkSection chunkSection : sectionArray) {
            if (chunkSection == null) continue;
            chunkSection.m_62981_();
            locked.add(chunkSection);
        }
        return CompletableFuture.supplyAsync(() -> {
            this.doPopulateNoise(chunkAccess);
            return chunkAccess;
        }, executor).thenApplyAsync(chunkx -> {
            for (LevelChunkSection chunkSection : locked) {
                chunkSection.m_63006_();
            }
            return chunkx;
        }, executor);
    }

    public void doPopulateNoise(ChunkAccess chunk) {
        ProtoChunk protoChunk = (ProtoChunk)chunk;
        ChunkPos pos = chunk.m_7697_();
        Heightmap oceanFloorHeightMap = protoChunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap surfaceHeightMap = protoChunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int regionX = Math.floorDiv(pos.f_45578_, 4);
        int regionZ = Math.floorDiv(pos.f_45579_, 4);
        RegionErrorTerrainGenerator generator = Helper.noError(() -> (RegionErrorTerrainGenerator)this.cache.get((Object)new ChunkPos(regionX, regionZ)));
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            LevelChunkSection section = protoChunk.m_183278_(sectionY);
            for (int localX = 0; localX < 16; ++localX) {
                for (int localZ = 0; localZ < 16; ++localZ) {
                    for (int localY = 0; localY < 16; ++localY) {
                        int worldX = pos.f_45578_ * 16 + localX;
                        int worldY = sectionY * 16 + localY;
                        int worldZ = pos.f_45579_ * 16 + localZ;
                        BlockState currBlockState = generator.getBlockComposition(worldX, worldY, worldZ);
                        if (currBlockState == this.air) continue;
                        section.m_62991_(localX, localY, localZ, currBlockState, false);
                        oceanFloorHeightMap.m_64249_(localX, worldY, localZ, currBlockState);
                        surfaceHeightMap.m_64249_(localX, worldY, localZ, currBlockState);
                    }
                }
            }
        }
    }
}

